#version 150
/* 
    WRP (World Resource Pack) shader for lightmap rendering
    Fullbright UB
*/

vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {

    float fogRedValue = ceil(fogColor.r * 255.0);
    float fogGreenValue = ceil(fogColor.g * 255.0);
    float fogBlueValue = ceil(fogColor.b * 255.0);

    vertexDistance = min(vertexDistance, fogEnd);

    // Ender Dragon Fog || Powder Snow Fog || Lava Fog
    if ((fogRedValue == 21 && fogGreenValue == 17 && fogBlueValue == 21)
    || (fogRedValue == 159 && fogGreenValue == 188 && fogBlueValue == 201)
    || (fogRedValue == 153 && fogGreenValue == 26 && fogBlueValue == 0 && fogColor.a != 0)) {
        return vec4(mix(inColor.rgb, fogColor.rgb,
                smoothstep(fogStart, fogEnd, vertexDistance) * fogColor.a / 1.5),
                inColor.a / 1.5);
    }

    // Blindness || Darkness Fogs || Water fix
    if (fogRedValue == 0 && fogGreenValue == 0 && fogBlueValue == 0 && fogColor.a != 0) {
        return vec4(mix(inColor.rgb, fogColor.rgb,
                smoothstep(fogStart, fogEnd, vertexDistance / 1.2) * fogColor.a / 1.2),
                inColor.a);
    }

    // Normal near fog
    if (fogColor.a == 1 && fogEnd < 100 && fogEnd > 20) {
        return vec4(mix(inColor.rgb, fogColor.rgb,
                smoothstep(fogStart, fogEnd, vertexDistance) * fogColor.a),
                inColor.a);
    }

    // No fog, only original color
    // This is used for the Nether and End, where fog is not applied
    if (fogColor.a > 0.0 && fogEnd > 100.0 && fogColor.r < 0.5 && fogColor.g < 0.5 && fogColor.b < 0.5) {
        return vec4(inColor.rgb, inColor.a);
    }

    if (vertexDistance / 2.0 < fogStart) {
        return inColor;
    }

    return vec4(mix(inColor.rgb, fogColor.rgb,
            smoothstep(fogStart, fogEnd, vertexDistance) * fogColor.a),
            fogColor.a);
}


float linear_fog_fade(float vertexDistance, float fogStart, float fogEnd) {

   
    if (vertexDistance <= fogStart) {
        return 1.0;
    } else if (vertexDistance >= fogEnd) {
        return 0.0;
    }

    return smoothstep(fogEnd, fogStart, vertexDistance);
}

float fog_distance(vec3 pos, int shape) {
    if (shape == 1) {
        return max(length(pos.xz), abs(pos.y));
        
    } else {
        return length(pos);
    }
	
}
