#version 150

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_ac93120f(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_2982b2de() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_a241d8af(inout vec4 vertex) {
    f_ac93120f(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_2982b2de();
    }
    finalize();
}



void f_a4658516() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_2dccb5d2() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_0901729d(inout vec4 vertex) {
    f_ac93120f(vertex);
    f_a4658516();
    finalize();
}

void f_31ed9b3a(inout vec4 vertex) {
    f_ac93120f(vertex);
    f_2982b2de();
    f_2dccb5d2();
    finalize();
}

void f_a55261ce(inout vec4 vertex) {
    f_ac93120f(vertex);
    f_2dccb5d2();
    f_a4658516();
    finalize();
}

void f_6aea00cf(inout vec4 vertex) {
    f_2982b2de();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_ac93120f(vertex);
    finalize();
}

void f_50e98051(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_a4658516();
    f_ac93120f(vertex);
    finalize();
}

void f_9f268cda(inout vec4 vertex, float speed) {
    f_ac93120f(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_0f7303bc(inout vec4 vertex) {
    f_ac93120f(vertex);
    f_2982b2de();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {
    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_a241d8af(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_2982b2de();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_ac93120f(vertex);
            f_2982b2de();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_31ed9b3a(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_31ed9b3a(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_6aea00cf(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_6aea00cf(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_9f268cda(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_0f7303bc(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_0901729d(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_31ed9b3a(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_a55261ce(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_6aea00cf(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_50e98051(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_9f268cda(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_0901729d(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_31ed9b3a(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_a55261ce(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_6aea00cf(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_50e98051(vertex);
        return;
    }
    

    
    f_ac93120f(vertex);
    f_2982b2de();
    finalize();
}