#version 150

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_aa8a382d(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_910e144e() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_a64e8a04(inout vec4 vertex) {
    f_aa8a382d(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_910e144e();
    }
    finalize();
}



void f_19cddba6() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_ad8c0f75() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_ccaaa7f5(inout vec4 vertex) {
    f_aa8a382d(vertex);
    f_19cddba6();
    finalize();
}

void f_cec84319(inout vec4 vertex) {
    f_aa8a382d(vertex);
    f_910e144e();
    f_ad8c0f75();
    finalize();
}

void f_a6cdbefa(inout vec4 vertex) {
    f_aa8a382d(vertex);
    f_ad8c0f75();
    f_19cddba6();
    finalize();
}

void f_ffc6ec66(inout vec4 vertex) {
    f_910e144e();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_aa8a382d(vertex);
    finalize();
}

void f_ea03cf7f(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_19cddba6();
    f_aa8a382d(vertex);
    finalize();
}

void f_1fefd66d(inout vec4 vertex, float speed) {
    f_aa8a382d(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_773b13f8(inout vec4 vertex) {
    f_aa8a382d(vertex);
    f_910e144e();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {
    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_a64e8a04(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_910e144e();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_aa8a382d(vertex);
            f_910e144e();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_cec84319(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_cec84319(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_ffc6ec66(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_ffc6ec66(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_1fefd66d(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_773b13f8(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_ccaaa7f5(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_cec84319(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_a6cdbefa(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_ffc6ec66(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_ea03cf7f(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_1fefd66d(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_ccaaa7f5(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_cec84319(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_a6cdbefa(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_ffc6ec66(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_ea03cf7f(vertex);
        return;
    }
    

    
    f_aa8a382d(vertex);
    f_910e144e();
    finalize();
}