#version 150

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_ee52266a(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_dd4bc7be() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_dc825283(inout vec4 vertex) {
    f_ee52266a(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_dd4bc7be();
    }
    finalize();
}



void f_26802f1d() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_954972e2() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_8684fe95(inout vec4 vertex) {
    f_ee52266a(vertex);
    f_26802f1d();
    finalize();
}

void f_2bcf91fd(inout vec4 vertex) {
    f_ee52266a(vertex);
    f_dd4bc7be();
    f_954972e2();
    finalize();
}

void f_543124fa(inout vec4 vertex) {
    f_ee52266a(vertex);
    f_954972e2();
    f_26802f1d();
    finalize();
}

void f_242415e5(inout vec4 vertex) {
    f_dd4bc7be();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_ee52266a(vertex);
    finalize();
}

void f_2203e1a7(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_26802f1d();
    f_ee52266a(vertex);
    finalize();
}

void f_f723c0f5(inout vec4 vertex, float speed) {
    f_ee52266a(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_2c802218(inout vec4 vertex) {
    f_ee52266a(vertex);
    f_dd4bc7be();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {
    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_dc825283(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_dd4bc7be();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_ee52266a(vertex);
            f_dd4bc7be();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_2bcf91fd(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_2bcf91fd(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_242415e5(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_242415e5(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_f723c0f5(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_2c802218(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_8684fe95(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_2bcf91fd(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_543124fa(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_242415e5(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_2203e1a7(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_f723c0f5(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_8684fe95(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_2bcf91fd(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_543124fa(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_242415e5(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_2203e1a7(vertex);
        return;
    }
    

    
    f_ee52266a(vertex);
    f_dd4bc7be();
    finalize();
}