#version 150

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_20a84e2f(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_d01bec27() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_4023fbef(inout vec4 vertex) {
    f_20a84e2f(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_d01bec27();
    }
    finalize();
}



void f_4a63220f() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_20342ea0() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_fc0a4b6d(inout vec4 vertex) {
    f_20a84e2f(vertex);
    f_4a63220f();
    finalize();
}

void f_564cb41a(inout vec4 vertex) {
    f_20a84e2f(vertex);
    f_d01bec27();
    f_20342ea0();
    finalize();
}

void f_03b55a42(inout vec4 vertex) {
    f_20a84e2f(vertex);
    f_20342ea0();
    f_4a63220f();
    finalize();
}

void f_a5c770ec(inout vec4 vertex) {
    f_d01bec27();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_20a84e2f(vertex);
    finalize();
}

void f_b9a0717b(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_4a63220f();
    f_20a84e2f(vertex);
    finalize();
}

void f_7553be83(inout vec4 vertex, float speed) {
    f_20a84e2f(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_9e294291(inout vec4 vertex) {
    f_20a84e2f(vertex);
    f_d01bec27();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {
    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_4023fbef(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_d01bec27();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_20a84e2f(vertex);
            f_d01bec27();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_564cb41a(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_564cb41a(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_a5c770ec(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_a5c770ec(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_7553be83(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_9e294291(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_fc0a4b6d(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_564cb41a(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_03b55a42(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_a5c770ec(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_b9a0717b(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_7553be83(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_fc0a4b6d(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_564cb41a(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_03b55a42(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_a5c770ec(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_b9a0717b(vertex);
        return;
    }
    

    
    f_20a84e2f(vertex);
    f_d01bec27();
    finalize();
}