#version 150

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_ec0aef7c(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_d3a24338() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_564e7747(inout vec4 vertex) {
    f_ec0aef7c(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_d3a24338();
    }
    finalize();
}



void f_dac22acf() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_799d058c() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_55fe1133(inout vec4 vertex) {
    f_ec0aef7c(vertex);
    f_dac22acf();
    finalize();
}

void f_8fbf6747(inout vec4 vertex) {
    f_ec0aef7c(vertex);
    f_d3a24338();
    f_799d058c();
    finalize();
}

void f_3b6bc7c6(inout vec4 vertex) {
    f_ec0aef7c(vertex);
    f_799d058c();
    f_dac22acf();
    finalize();
}

void f_57c7f53c(inout vec4 vertex) {
    f_d3a24338();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_ec0aef7c(vertex);
    finalize();
}

void f_57e33da5(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_dac22acf();
    f_ec0aef7c(vertex);
    finalize();
}

void f_497e6616(inout vec4 vertex, float speed) {
    f_ec0aef7c(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_6089de4a(inout vec4 vertex) {
    f_ec0aef7c(vertex);
    f_d3a24338();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {
    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_564e7747(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_d3a24338();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_ec0aef7c(vertex);
            f_d3a24338();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_8fbf6747(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_8fbf6747(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_57c7f53c(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_57c7f53c(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_497e6616(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_6089de4a(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_55fe1133(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_8fbf6747(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_3b6bc7c6(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_57c7f53c(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_57e33da5(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_497e6616(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_55fe1133(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_8fbf6747(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_3b6bc7c6(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_57c7f53c(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_57e33da5(vertex);
        return;
    }
    

    
    f_ec0aef7c(vertex);
    f_d3a24338();
    finalize();
}