#version 150

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_2f290d24(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_3c8b1458() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_b6b530b3(inout vec4 vertex) {
    f_2f290d24(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_3c8b1458();
    }
    finalize();
}



void f_3b7fefb1() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_036de9ac() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_1635ff11(inout vec4 vertex) {
    f_2f290d24(vertex);
    f_3b7fefb1();
    finalize();
}

void f_c66e1388(inout vec4 vertex) {
    f_2f290d24(vertex);
    f_3c8b1458();
    f_036de9ac();
    finalize();
}

void f_c97c3b82(inout vec4 vertex) {
    f_2f290d24(vertex);
    f_036de9ac();
    f_3b7fefb1();
    finalize();
}

void f_f7085c4c(inout vec4 vertex) {
    f_3c8b1458();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_2f290d24(vertex);
    finalize();
}

void f_9a242148(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_3b7fefb1();
    f_2f290d24(vertex);
    finalize();
}

void f_326f8660(inout vec4 vertex, float speed) {
    f_2f290d24(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_2eb7e393(inout vec4 vertex) {
    f_2f290d24(vertex);
    f_3c8b1458();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {
    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_b6b530b3(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_3c8b1458();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_2f290d24(vertex);
            f_3c8b1458();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_c66e1388(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_c66e1388(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_f7085c4c(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_f7085c4c(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_326f8660(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_2eb7e393(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_1635ff11(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_c66e1388(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_c97c3b82(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_f7085c4c(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_9a242148(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_326f8660(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_1635ff11(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_c66e1388(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_c97c3b82(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_f7085c4c(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_9a242148(vertex);
        return;
    }
    

    
    f_2f290d24(vertex);
    f_3c8b1458();
    finalize();
}