#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:projection.glsl>
#moj_import <minecraft:globals.glsl> 

precision highp float;






#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

out float sphericalVertexDistance;
out float cylindricalVertexDistance;

float safeGameTime() {
    float gameTime=GameTime;
    
    if(gameTime <= 0) {
        gameTime=.5;
    }
    return gameTime;
}

float scaledTime() {
    return safeGameTime()*12000.;
}

void f_7c9f53b7(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_45e92dc2() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_d3462ff4(inout vec4 vertex) {
    f_7c9f53b7(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_45e92dc2();
    }
    finalize();
}



void f_3c455872() {
    vertexColor=hue(gl_Position.x+safeGameTime()*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_d57d686c() {
    gl_Position.y+=sin(scaledTime()+(gl_Position.x*6)) / 150.;
}

void f_15fbebbf(inout vec4 vertex) {
    f_7c9f53b7(vertex);
    f_3c455872();
    finalize();
}

void f_8ed1a731(inout vec4 vertex) {
    f_7c9f53b7(vertex);
    f_45e92dc2();
    f_d57d686c();
    finalize();
}

void f_467c090a(inout vec4 vertex) {
    f_7c9f53b7(vertex);
    f_d57d686c();
    f_3c455872();
    finalize();
}

void f_35d6ec53(inout vec4 vertex) {
    f_45e92dc2();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_7c9f53b7(vertex);
    finalize();
}

void f_602092f8(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(scaledTime() / 4)*.1;
            vertex.y+=max(cos(scaledTime() / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(scaledTime() / 4)*3;
            vertex.y-=max(cos(scaledTime() / 4)*4, 0.);
        }
    }
    f_3c455872();
    f_7c9f53b7(vertex);
    finalize();
}

void f_3d2ca069(inout vec4 vertex, float speed) {
    f_7c9f53b7(vertex);
    float blink=abs(sin(scaledTime()*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_6ac93096(inout vec4 vertex) {
    f_7c9f53b7(vertex);
    f_45e92dc2();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {

    sphericalVertexDistance=fog_spherical_distance(Position);
    cylindricalVertexDistance=fog_cylindrical_distance(Position);
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);

    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_d3462ff4(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_45e92dc2();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_7c9f53b7(vertex);
            f_45e92dc2();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_8ed1a731(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_8ed1a731(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_35d6ec53(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_35d6ec53(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_3d2ca069(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_6ac93096(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_15fbebbf(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_8ed1a731(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_467c090a(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_35d6ec53(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_602092f8(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_3d2ca069(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_15fbebbf(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_8ed1a731(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_467c090a(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_35d6ec53(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_602092f8(vertex);
        return;
    }
    

    
    f_7c9f53b7(vertex);
    f_45e92dc2();
    finalize();
}